﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace ErrorExample
{
    class Turtle
    {
        // Szerokość platformy robota
        public double PlatformWidth
        {
            get;
            set;
        }

        // Wysokość platformy robota
        public double PlatformHeight
        {
            get;
            set;
        }

        // Szybkość, z jaką silniczki kręcą kółkami,
        // wyrażona w metrach na sekundę. Dla ułatwienia zakładamy,
        // że została ona określona na podstawie dystansu, jaki pokonały 
        // kółka robota na powierzchni, po której się porusza
        // (i ewentualnych poślizgów).
        public double MotorSpeed
        {
            get;
            set;
        }

        // Stan lewego silniczka
        public MotorState LeftMotorState
        {
            get;
            set;
        }

        // Stan prawego silniczka
        public MotorState RightMotorState
        {
            get;
            set;
        }

        // Aktualne położenie robota
        public Point CurrentPosition
        {
            get;
            private set;
        }

        // Aktualna orientacja robota
        public double CurrentOrientation
        {
            get;
            private set;
        }


        // Przykład 6-17. Ponowne zgłaszanie wyjątku.
        // Robot się porusza przez zadany okres czasu.
        public void RunFor(double duration)
        {
            try
            {
                if (LeftMotorState == MotorState.Stopped &&
                    RightMotorState == MotorState.Stopped)
                {
                    // Jeśli robot był całkowicie zatrzymany, nic się nie stanie.
                    return;
                }

                // Jeśli oba silniczki pracowały, kręcąc się w tym samym kierunku,
                // to mogliśmy jechać.
                if ((LeftMotorState == MotorState.Running &&
                    RightMotorState == MotorState.Running) ||
                    (LeftMotorState == MotorState.Reversed &&
                    RightMotorState == MotorState.Reversed))
                {
                    Drive(duration);
                }

                // Silniczki kręcą się w przeciwnych kierunkach,
                // zatem robot nie jedzie do przodu, a jedynie kręci 
                // się wokół swego środka.
                if ((LeftMotorState == MotorState.Running &&
                    RightMotorState == MotorState.Reversed) ||
                    (LeftMotorState == MotorState.Reversed &&
                    RightMotorState == MotorState.Running))
                {
                    Rotate(duration);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Informacja do dziennika: " + ex.Message);
                // Ponowne zgłoszenie wyjątku
                throw;
            }
        }

        private void Rotate(double duration)
        {
            if (PlatformWidth <= 0.0)
            {
                throw new InvalidOperationException(
                    "Właściwości PlatformWidth należy przypisać wartość > 0.0.");
            }
            // Pełna długość okręgu zataczanego przez obracającego się robota.
            double circum = Math.PI * PlatformWidth;
            // Całkowity przebyty dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w tył, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Stosunek przebytego dystansu do obwodu pełnego obrotu
            double proportionOfWholeCircle = d / circum;
            // Gdy obrót wyniesie 360 stopni (lub 2pi radianów), to przebyta 
            // odległość wyniesie:
            CurrentOrientation =
                CurrentOrientation + (Math.PI * 2.0 * proportionOfWholeCircle);
            // return true; (Teraz zwracanie wartości jest niepotrzebne,
            // więc można tę instrukcję usunąć).
        }


        private void Drive(double duration)
        {
            // Całkowity przejechany dystans
            double d = duration * MotorSpeed;
            if (LeftMotorState == MotorState.Reversed)
            {
                // Jeśli silniczki kręcą się w ty, to jedziemy do tyłu.
                d *= -1.0;
            }
            // Nieco obliczeń trygonometrycznych w celu określenia zmiany
            // współrzędnych x i y
            double deltaX = d * Math.Sin(CurrentOrientation);
            double deltaY = d * Math.Cos(CurrentOrientation);
            // Zaktualizowane położenie robota
            CurrentPosition =
                new Point(CurrentPosition.X + deltaX, CurrentPosition.Y + deltaY);
        }
    }
    // Aktualny stan silniczka
    enum MotorState
    {
        Stopped,
        Running,
        Reversed
    }
}
